from bpy.types import PropertyGroup
from bpy.props import IntProperty, FloatProperty, BoolProperty, EnumProperty


class ActiveEmitterSpringsAnimProps(PropertyGroup):
    
    """ active_emitter_item.springs.anim.x """

    spring_force_start: IntProperty(name="Start", description="Start at Frame", default=1)
    spring_force_duration: IntProperty(name="Duration", description="Duration", default=10)
    spring_force_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    spring_force_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    spring_force_from: FloatProperty(name="From", description="From value x", default=0.04)
    spring_force_to: FloatProperty(name="To", description="To value x", default=0.0001)
    spring_force_animed: BoolProperty(default=False)
    spring_force_inc_dec: BoolProperty(default=False)

    use_viscoelastic_springs_start: IntProperty(name="Start", description="Start at Frame", default=1)
    use_viscoelastic_springs_from_to: EnumProperty(
        items=[
            ('ON_OFF', "On to Off", "", 0),
            ('OFF_ON', "Off to On", "", 1),
        ]
    )
    use_viscoelastic_springs_animed: BoolProperty(default=False)